<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CalendarView.
 */
class CalendarView  {

  /*
   * @type String
   */
  public $label;

  /*
   * @type CalendarViewCalendarViewType
   */
  public $type;

  /*
   * @type boolean
   */
  public $isDefault;

  /*
   * @type List
   */
  public $calendars;

  /*
   * Constructor
   */
  public function __construct() {
    $this->label = "";
    $this->isDefault = false;
    $this->calendars =  array();
  }

  public function toMap() {
    $data = array(    
        "label" => empty($this->label) ? null : $this->label,    
        "type" => empty($this->type) ? null : $this->type,    
        "isDefault" => empty($this->isDefault) ? null : $this->isDefault,    
        "calendars" => empty($this->calendars) ? null : $this->calendars);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
