/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageSearchResultGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageSearchResult> {

	public MessageSearchResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageSearchResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageSearchResult ret = new net.bluemind.backend.mail.api.MessageSearchResult();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageSearchResult ret, JSONObject json) {
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue itemIdJSON = json.get("itemId");
		ret.itemId =  GwtSerDerUtils.LONG.deserialize(itemIdJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue messageClassJSON = json.get("messageClass");
		ret.messageClass =  GwtSerDerUtils.STRING.deserialize(messageClassJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(fromJSON);
		JSONValue toJSON = json.get("to");
		ret.to =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(toJSON);
		JSONValue seenJSON = json.get("seen");
		ret.seen =  GwtSerDerUtils.BOOLEAN.deserialize(seenJSON);
		JSONValue flaggedJSON = json.get("flagged");
		ret.flagged =  GwtSerDerUtils.BOOLEAN.deserialize(flaggedJSON);
		JSONValue hasAttachmentJSON = json.get("hasAttachment");
		ret.hasAttachment =  GwtSerDerUtils.BOOLEAN.deserialize(hasAttachmentJSON);
		JSONValue previewJSON = json.get("preview");
		ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
		JSONValue scoreJSON = json.get("score");
		ret.score =  GwtSerDerUtils.DOUBLE.deserialize(scoreJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageSearchResult ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("containerUid")) {
			JSONValue containerUidJSON = json.get("containerUid");
			ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		}
		if (!childPropertiesToIgnore.contains("itemId")) {
			JSONValue itemIdJSON = json.get("itemId");
			ret.itemId =  GwtSerDerUtils.LONG.deserialize(itemIdJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("messageClass")) {
			JSONValue messageClassJSON = json.get("messageClass");
			ret.messageClass =  GwtSerDerUtils.STRING.deserialize(messageClassJSON);
		}
		if (!childPropertiesToIgnore.contains("date")) {
			JSONValue dateJSON = json.get("date");
			ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		}
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(fromJSON);
		}
		if (!childPropertiesToIgnore.contains("to")) {
			JSONValue toJSON = json.get("to");
			ret.to =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(toJSON);
		}
		if (!childPropertiesToIgnore.contains("seen")) {
			JSONValue seenJSON = json.get("seen");
			ret.seen =  GwtSerDerUtils.BOOLEAN.deserialize(seenJSON);
		}
		if (!childPropertiesToIgnore.contains("flagged")) {
			JSONValue flaggedJSON = json.get("flagged");
			ret.flagged =  GwtSerDerUtils.BOOLEAN.deserialize(flaggedJSON);
		}
		if (!childPropertiesToIgnore.contains("hasAttachment")) {
			JSONValue hasAttachmentJSON = json.get("hasAttachment");
			ret.hasAttachment =  GwtSerDerUtils.BOOLEAN.deserialize(hasAttachmentJSON);
		}
		if (!childPropertiesToIgnore.contains("preview")) {
			JSONValue previewJSON = json.get("preview");
			ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
		}
		if (!childPropertiesToIgnore.contains("score")) {
			JSONValue scoreJSON = json.get("score");
			ret.score =  GwtSerDerUtils.DOUBLE.deserialize(scoreJSON);
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageSearchResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageSearchResult o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("itemId",  GwtSerDerUtils.LONG.serialize( o.itemId ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("messageClass",  GwtSerDerUtils.STRING.serialize( o.messageClass ));
		ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		ret.put("from",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.from ));
		ret.put("to",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.to ));
		ret.put("seen",  GwtSerDerUtils.BOOLEAN.serialize( o.seen ));
		ret.put("flagged",  GwtSerDerUtils.BOOLEAN.serialize( o.flagged ));
		ret.put("hasAttachment",  GwtSerDerUtils.BOOLEAN.serialize( o.hasAttachment ));
		ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
		ret.put("score",  GwtSerDerUtils.DOUBLE.serialize( o.score ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageSearchResult o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("containerUid")) {
			ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		}
		if (!childPropertiesToIgnore.contains("itemId")) {
			ret.put("itemId",  GwtSerDerUtils.LONG.serialize( o.itemId ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("messageClass")) {
			ret.put("messageClass",  GwtSerDerUtils.STRING.serialize( o.messageClass ));
		}
		if (!childPropertiesToIgnore.contains("date")) {
			ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		}
		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.from ));
		}
		if (!childPropertiesToIgnore.contains("to")) {
			ret.put("to",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.to ));
		}
		if (!childPropertiesToIgnore.contains("seen")) {
			ret.put("seen",  GwtSerDerUtils.BOOLEAN.serialize( o.seen ));
		}
		if (!childPropertiesToIgnore.contains("flagged")) {
			ret.put("flagged",  GwtSerDerUtils.BOOLEAN.serialize( o.flagged ));
		}
		if (!childPropertiesToIgnore.contains("hasAttachment")) {
			ret.put("hasAttachment",  GwtSerDerUtils.BOOLEAN.serialize( o.hasAttachment ));
		}
		if (!childPropertiesToIgnore.contains("preview")) {
			ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
		}
		if (!childPropertiesToIgnore.contains("score")) {
			ret.put("score",  GwtSerDerUtils.DOUBLE.serialize( o.score ));
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}