/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFinderResponseGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MailFinderResponse> {

	public MailFinderResponseGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MailFinderResponse deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MailFinderResponse ret = new net.bluemind.backend.mail.api.MailFinderResponse();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailFinderResponse ret, JSONObject json) {
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue imapUidJSON = json.get("imapUid");
		ret.imapUid =  GwtSerDerUtils.INT.deserialize(imapUidJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailFinderResponse ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("containerUid")) {
			JSONValue containerUidJSON = json.get("containerUid");
			ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		}
		if (!childPropertiesToIgnore.contains("imapUid")) {
			JSONValue imapUidJSON = json.get("imapUid");
			ret.imapUid =  GwtSerDerUtils.INT.deserialize(imapUidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MailFinderResponse o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailFinderResponse o, JSONObject ret) {

		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("imapUid",  GwtSerDerUtils.INT.serialize( o.imapUid ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailFinderResponse o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("containerUid")) {
			ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		}
		if (!childPropertiesToIgnore.contains("imapUid")) {
			ret.put("imapUid",  GwtSerDerUtils.INT.serialize( o.imapUid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}