/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ImapItemIdentifierGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.ImapItemIdentifier> {

	private net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer parent = new  net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer();
	public ImapItemIdentifierGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.ImapItemIdentifier deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.ImapItemIdentifier ret = new net.bluemind.backend.mail.api.ImapItemIdentifier();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.ImapItemIdentifier ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue imapUidJSON = json.get("imapUid");
		ret.imapUid =  GwtSerDerUtils.LONG.deserialize(imapUidJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.ImapItemIdentifier ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("imapUid")) {
			JSONValue imapUidJSON = json.get("imapUid");
			ret.imapUid =  GwtSerDerUtils.LONG.deserialize(imapUidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.ImapItemIdentifier o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.ImapItemIdentifier o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("imapUid",  GwtSerDerUtils.LONG.serialize( o.imapUid ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.ImapItemIdentifier o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("imapUid")) {
			ret.put("imapUid",  GwtSerDerUtils.LONG.serialize( o.imapUid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}