/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailboxItemsSockJsEndpoint implements net.bluemind.backend.mail.api.IMailboxItemsAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailboxItemsSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_items/{replicatedMailboxUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{replicatedMailboxUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public MailboxItemsSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void addFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_addFlag";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.FlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void changeset(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler) {
		String postUri = "/_changeset";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("since", URL.encodeQueryString(""+since));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerChangeset<String>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerChangeset<String> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void changesetById(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler) {
		String postUri = "/_changesetById";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("since", URL.encodeQueryString(""+since));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerChangeset<Long>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerChangeset<Long> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void count(net.bluemind.core.container.model.ItemFlagFilter arg0, final AsyncHandler<net.bluemind.core.container.api.Count> handler) {
		String postUri = "/_count";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Count>(handler) {
					@Override
			protected net.bluemind.core.container.api.Count handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.CountGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(net.bluemind.backend.mail.api.MailboxItem value, final AsyncHandler<net.bluemind.backend.mail.api.ImapItemIdentifier> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer().serialize( value);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.backend.mail.api.ImapItemIdentifier>(handler) {
					@Override
			protected net.bluemind.backend.mail.api.ImapItemIdentifier handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.backend.mail.api.gwt.serder.ImapItemIdentifierGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void createById(long id, net.bluemind.backend.mail.api.MailboxItem arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void deleteById(long id, final AsyncHandler<Void> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void deleteFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_deleteFlag";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.FlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void expunge(final AsyncHandler<Void> handler) {
		String postUri = "/_expunge";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void fetch(long imapUid, String address, String encoding, String mime, String charset, String filename, final AsyncHandler<Stream> handler) {
		String postUri = "/part/{imapUid}/{address}";

		postUri = postUri.replace("{imapUid}", URL.encodePathSegment(""+imapUid));
		postUri = postUri.replace("{address}", URL.encodePathSegment(""+address));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("encoding", URL.encodeQueryString(""+encoding));
		params.put("mime", URL.encodeQueryString(""+mime));
		params.put("charset", URL.encodeQueryString(""+charset));
		params.put("filename", URL.encodeQueryString(""+filename));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void fetchComplete(long imapUid, final AsyncHandler<Stream> handler) {
		String postUri = "/eml/{imapUid}";

		postUri = postUri.replace("{imapUid}", URL.encodePathSegment(""+imapUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void fetchCompleteByGuid(String guid, final AsyncHandler<Stream> handler) {
		String postUri = "/eml_by_guid/{guid}";

		postUri = postUri.replace("{guid}", URL.encodePathSegment(""+guid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void filteredChangesetById(Long since, net.bluemind.core.container.model.ItemFlagFilter arg1, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler) {
		String postUri = "/_filteredChangesetById";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("since", URL.encodeQueryString(""+since));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getCompleteById(long id, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> handler) {
		String postUri = "/{id}/completeById";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getForUpdate(long id, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> handler) {
		String postUri = "/{id}/getForUpdate";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getVersion(final AsyncHandler<Long> handler) {
		String postUri = "/_version";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Long>(handler) {
					@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void itemChangelog(String uid, Long arg1, final AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler) {
		String postUri = "/{uid}/_itemchangelog";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.LONG.serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemChangelog>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemChangelog handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemChangelogGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void listItemIdsAfter(net.bluemind.core.api.date.BmDateTime before, final AsyncHandler<List<Long>> handler) {
		String postUri = "/_list_after_date";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( before);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<Long>>(handler) {
					@Override
			protected List<Long> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void multipleDeleteById(List<Long> arg0, Boolean bypassDeletedItems, final AsyncHandler<Void> handler) {
		String postUri = "/_multipleDelete";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("bypassDeletedItems", URL.encodeQueryString(""+bypassDeletedItems));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void multipleGetById(List<Long> arg0, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>> handler) {
		String postUri = "/_mgetById";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void multipleUnexpungeById(List<Long> itemIds, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/_multipleUnexpunge";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( itemIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void recentItems(java.util.Date deliveredOrUpdatedAfter, final AsyncHandler<List<Long>> handler) {
		String postUri = "/_recent";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.DATE.serialize( deliveredOrUpdatedAfter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<Long>>(handler) {
					@Override
			protected List<Long> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void removePart(String partId, final AsyncHandler<Void> handler) {
		String postUri = "/{partId}/_part";

		postUri = postUri.replace("{partId}", URL.encodePathSegment(""+partId));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void sortedIds(net.bluemind.core.container.model.SortDescriptor arg0, final AsyncHandler<List<Long>> handler) {
		String postUri = "/_sorted";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.SortDescriptorGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<Long>>(handler) {
					@Override
			protected List<Long> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void sortedUids(net.bluemind.core.container.model.SortDescriptor arg0, final AsyncHandler<List<String>> handler) {
		String postUri = "/_sorteduids";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.SortDescriptorGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void unexpunge(long itemId, final AsyncHandler<net.bluemind.core.container.model.ItemIdentifier> handler) {
		String postUri = "/_unexpunge/{itemId}";

		postUri = postUri.replace("{itemId}", URL.encodePathSegment(""+itemId));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemIdentifier>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemIdentifier handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void unreadItems(final AsyncHandler<List<Long>> handler) {
		String postUri = "/_unread";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<Long>>(handler) {
					@Override
			protected List<Long> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void updateById(long id, net.bluemind.backend.mail.api.MailboxItem arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.gwt.serder.MailboxItemGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void uploadPart(Stream part, final AsyncHandler<String> handler) {
		String postUri = "/_part";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( part);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.backend.mail.api.IMailboxItemsPromise promiseApi() {
		return new MailboxItemsEndpointPromise(this);
	}

}
