/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailFinderEndpointPromise implements net.bluemind.backend.mail.api.IMailFinderPromise {

	private net.bluemind.backend.mail.api.IMailFinderAsync impl;

	public MailFinderEndpointPromise(net.bluemind.backend.mail.api.IMailFinderAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.SearchResult> search(net.bluemind.backend.mail.api.MailFinderQuery query  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.SearchResult> ret = new CompletableFuture<net.bluemind.backend.mail.api.SearchResult>();
		AsyncHandler<net.bluemind.backend.mail.api.SearchResult> handler = new AsyncHandler<net.bluemind.backend.mail.api.SearchResult>() {
			public void success(net.bluemind.backend.mail.api.SearchResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}

}
