/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.api;

import java.util.Date;

import com.google.common.base.MoreObjects;

import net.bluemind.backend.mail.api.Conversation.MessageRef;

public class InternalMessageRef {
	public String folderUid;
	public long itemId;
	public Date date;
	public String subject;
	public String sender;
	public int size;
	public long conversationId;
	public boolean unseen;
	public boolean flagged;

	public MessageRef toMessageRef() {
		MessageRef ref = new MessageRef();
		ref.folderUid = folderUid;
		ref.itemId = itemId;
		ref.date = date;
		return ref;
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(InternalMessageRef.class).add("id", itemId).add("d", date.toInstant())
				.add("from", sender).add("sub", subject).toString();
	}
}