/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.cql.store;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.api.Email;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.model.Item;
import net.bluemind.directory.repository.DirEntryNG;
import net.bluemind.mailbox.api.IMailboxes.MailboxLocation;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.api.Mailbox.Routing;
import net.bluemind.mailbox.repository.IMailboxStore;

public class CqlMailboxStore implements IMailboxStore {

	private final CqlDirEntryNgStore deStore;
	private final DataLocation constLoc;

	public CqlMailboxStore(CqlSession s, Container c, DataLocation constLoc) {
		this.deStore = new CqlDirEntryNgStore(s, c);
		this.constLoc = constLoc;
	}

	@Override
	public void create(Item item, Mailbox value) throws SQLException {
		throw new UnsupportedOperationException("insert dir entry instead");
	}

	@Override
	public void update(Item item, Mailbox value) throws SQLException {
		DirEntryNG de = deStore.get(item);
		de.mailboxName = value.name;
		de.routing = value.routing;
		de.emails = List.copyOf(value.emails);
		deStore.update(item, de);
	}

	@Override
	public void delete(Item item) throws SQLException {
		throw new UnsupportedOperationException("insert dir entry instead");
	}

	@Override
	public Mailbox get(Item item) throws SQLException {
		DirEntryNG de = deStore.get(item);
		return de.asMailbox();
	}

	@Override
	public void deleteAll() throws SQLException {
		throw new UnsupportedOperationException("insert dir entry instead");
	}

	@Override
	public List<Mailbox> getMultiple(List<Item> items) throws SQLException {
		return deStore.getMultiple(items).stream().map(DirEntryNG::asMailbox).toList();
	}

	@Override
	public boolean exists(Item item) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean nameAlreadyUsed(Long itemId, Mailbox mbox) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean emailAlreadyUsed(Long itemId, Collection<Email> emails) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public String emailSearch(String email) throws SQLException {
		return Optional.ofNullable(deStore.byEmail(email)).map(i -> i.uid).orElse(null);
	}

	@Override
	public String nameSearch(String name) throws SQLException {
		return Optional.ofNullable(deStore.byMailboxName(name)).map(i -> i.uid).orElse(null);
	}

	@Override
	public List<String> routingSearch(Routing routing) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> allUids() throws SQLException {
		return deStore.mailboxUids();
	}

	@Override
	public Optional<MailboxLocation> getLocation(String ownerUid) throws SQLException {
		Item asItem = deStore.byOwnerUid(ownerUid);

		return Optional.ofNullable(asItem).map(it -> deStore.get(it))
				.map(de -> new MailboxLocation(de.mailboxName, constLoc.serverUid()));
	}

}
