/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.server.cql.store;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

import net.bluemind.server.api.Assignment;
import net.bluemind.server.repository.IServerAssignmentStore;

public class CqlNoopAssignments implements IServerAssignmentStore {

	@Override
	public void assign(String serverUid, String domainUid, String tag) throws SQLException {
		// NOOP
	}

	@Override
	public List<Assignment> getAssignments(String domainUid) throws SQLException {
		return Collections.emptyList();
	}

	@Override
	public List<Assignment> getServerAssignments(String uid) throws SQLException {
		return Collections.emptyList();
	}

	@Override
	public void pruneStaleAssignments() throws SQLException {
		// NOOP
	}

	@Override
	public void unassign(String serverUid, String domainUid, String tag) throws SQLException {
		// NOOP
	}

	@Override
	public void unassignFromDomain(String domainUid) throws SQLException {
		// NOOP
	}

}
