/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.lib.vertx.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import net.bluemind.memory.pool.api.ChunkFiler;
import net.bluemind.memory.pool.api.ChunkFiler.NamedChunk;

public class StreamToChunk {

	@SuppressWarnings("serial")
	private static class StreamToChunkException extends RuntimeException {

		public StreamToChunkException(IOException e) {
			super(e);
		}

	}

	private StreamToChunk() {

	}

	public static String filerAddress(ReadStream<Buffer> classic, int maxSize) {
		try {
			NamedChunk addr = ChunkFiler.newNamedChunk(maxSize);
			ChunkWriteStream cws = new ChunkWriteStream(addr.chunk());
			CompletableFuture<Void> xFer = new CompletableFuture<>();
			Thread.ofVirtual().name("tx-to-chunk").start(() -> {
				CompletableFuture<Void> prom = classic.pipeTo(cws).toCompletionStage().toCompletableFuture();
				prom.whenComplete((v, ex) -> {
					if (ex != null) {
						xFer.completeExceptionally(ex);
					} else {
						xFer.complete(null);
					}
				});
				classic.resume();
			});
			return xFer.orTimeout(30, TimeUnit.SECONDS).thenApply(v -> addr.name()).join();
		} catch (IOException e) {
			throw new StreamToChunkException(e);
		}
	}

}
