/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2020
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.milter.action.misc.updatesubject;

import java.util.Map;

import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.mailflow.rbe.IClientContext;
import net.bluemind.milter.action.MilterAction;
import net.bluemind.milter.action.MilterActionsFactory;
import net.bluemind.milter.action.UpdatedMailMessage;

public class SanitizeSubjectAction implements MilterAction {
	private static final String identifier = "SanitizeSubjectAction";
	private static final Logger logger = LoggerFactory.getLogger(SanitizeSubjectAction.class);

	public static class SanitizeSubjectActionFactory implements MilterActionsFactory {
		@Override
		public MilterAction create() {
			return new SanitizeSubjectAction();
		}
	}

	@Override
	public String identifier() {
		return identifier;
	}

	@Override
	public String description() {
		return "Sanitize mail subject encoding";
	}

	@Override
	public void execute(UpdatedMailMessage modifier, Map<String, String> configuration,
			Map<String, String> evaluationData, IClientContext mailflowContext) {

		Field subject = modifier.getMessage().getHeader().getField(FieldName.SUBJECT);
		if (subject != null && EmailHeaderEncoder.containsNonAscii(subject.getBody())) {
			String encodedSubject = EmailHeaderEncoder.encodeHeaderValue(subject.getBody());
			logger.debug("Subject has been modified from {} to {}", subject.getBody(), encodedSubject);
			modifier.removeHeader(FieldName.SUBJECT);
			modifier.addHeader(FieldName.SUBJECT, encodedSubject, identifier);
		}
	}
}
