package net.bluemind.cql.persistence;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.google.common.io.CharStreams;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.cql.schemas.CqlSchemaDescriptor;

public class CqlSchemaStore {

	private static final Logger logger = LoggerFactory.getLogger(CqlSchemaStore.class);
	private final CqlSession cs;

	public CqlSchemaStore(CqlSession cs) {
		this.cs = cs;
	}

	public void create(CqlSchemaDescriptor desc) {
		try (InputStreamReader in = new InputStreamReader(desc.schema().openStream())) {
			String content = CharStreams.toString(in);
			List<String> statements = Splitter.on(';').trimResults().omitEmptyStrings().splitToList(content);
			logger.info("Create {} with {} statement(s)", desc, statements.size());
			runStatements(statements);
		} catch (IOException e) {
			throw new ServerFault(e);
		}
	}

	private void runStatements(List<String> statements) {
		for (String ddl : statements) {
			try {
				cs.execute(ddl);
			} catch (Exception e) {
				throw new ServerFault("DDL error " + e.getMessage() + " '" + ddl + "'", e);
			}
		}
	}

}
