package net.bluemind.cql.persistence;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.schemas.CqlKeyspaceDescriptor;

public class CqlKeyspaceStore {

	private final CqlSession cs;
	private static final String KS_TRAIL = CqlSessions.UNSAFE_FOR_TESTS ? "AND durable_writes = false" : "";

	public CqlKeyspaceStore(CqlSession cs) {
		this.cs = cs;
	}

	public void createKeyspace(CqlKeyspaceDescriptor ks) {
		if (CqlSessions.UNSAFE_FOR_TESTS) {
			String drop = """
					DROP KEYSPACE IF EXISTS %s
					""".formatted(ks.id());
			cs.execute(drop);
		}
		String ksQuery = """
				CREATE KEYSPACE IF NOT EXISTS %s
				WITH REPLICATION = {
				 'class' : 'NetworkTopologyStrategy',
				 'datacenter1' : 1
				}
				AND TABLETS = {'enabled': false}
				%s
				""".formatted(ks.id(), KS_TRAIL);
		cs.execute(ksQuery);

	}

}
