/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.service.internal;

import java.sql.SQLException;
import java.time.Instant;

import net.bluemind.backend.mail.replica.api.IInternelMessageBodyPurgeQueue;
import net.bluemind.backend.mail.repository.IMessageBodyPurgeQueueStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.repository.provider.RepositoryProvider;

public class MessageBodyPurgeQueueService implements IInternelMessageBodyPurgeQueue {
	public static class Factory
			implements ServerSideServiceProvider.IServerSideServiceFactory<IInternelMessageBodyPurgeQueue> {
		@Override
		public Class<IInternelMessageBodyPurgeQueue> factoryClass() {
			return IInternelMessageBodyPurgeQueue.class;
		}

		@Override
		public IInternelMessageBodyPurgeQueue instance(BmContext context, String... params) {
			return new MessageBodyPurgeQueueService(context,
					RepositoryProvider.instance(IMessageBodyPurgeQueueStore.class, context));
		}
	}

	private IMessageBodyPurgeQueueStore store;

	public MessageBodyPurgeQueueService(BmContext context, IMessageBodyPurgeQueueStore store) {
		this.store = store;
	}

	@Override
	public boolean createOrUpdate(String guid, Instant created, Instant removed, boolean immediate_remove) {
		try {
			return store.createOrUpdate(guid, created, removed, immediate_remove);
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}

	@Override
	public long delete(String messageBodyGuid) {
		try {
			return store.delete(messageBodyGuid);
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}

	@Override
	public void deleteAll() {
		try {
			store.deleteAll();
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}

	@Override
	public void enableReplicationTriggers() {
		try {
			store.enableReplicationTriggers();
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}

	@Override
	public void disableReplicationTriggers() {
		try {
			store.disableReplicationTriggers();
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}

	@Override
	public void resyncToKafka() {
		try {
			store.resyncToKafka();
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
	}
}
