/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License)
 * or the CeCILL as published by CeCILL.info (version 2 of the License).
 *
 * There are special exceptions to the terms and conditions of the
 * licenses as they are applied to this program. See LICENSE.txt in
 * the directory of this program distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.replica.service;

import net.bluemind.backend.mail.api.IMailFinder;
import net.bluemind.backend.mail.replica.service.internal.MailFinderService;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.service.internal.RBACManager;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.directory.api.IDirectory;
import net.bluemind.domain.api.Domain;
import net.bluemind.domain.api.IDomains;

public class MailFinderServiceFactory implements ServerSideServiceProvider.IServerSideServiceFactory<IMailFinder> {

	@Override
	public Class<IMailFinder> factoryClass() {
		return IMailFinder.class;
	}

	@Override
	public IMailFinder instance(BmContext context, String... params) throws ServerFault {
		if (params == null || params.length < 1) {
			throw new ServerFault("wrong number of instance parameters");
		}
		String domainUid = params[0];
		IDomains domainsApi = context.provider().instance(IDomains.class);
		ItemValue<Domain> domain = domainsApi.findByNameOrAliases(domainUid);
		if (domain == null) {
			throw new ServerFault("domain '" + domainUid + "' cannot be found");
		}

		IDirectory dirApi = context.provider().instance(IDirectory.class, domain.uid);
		RBACManager rbacManager = new RBACManager(context);
		return new MailFinderService(domain, dirApi, rbacManager);
	}

}
