package net.bluemind.backend.mail.replica.service;

import java.sql.SQLException;
import java.util.List;
import java.util.function.Supplier;

import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.hook.IMessageBodyHook;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.repository.IItemValueStore;
import net.bluemind.core.container.repository.IWeightProvider;
import net.bluemind.core.container.service.internal.ContainerStoreService;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.rest.BmContext;

public class HookMailboxRecordStoreService extends ContainerStoreService<MailboxRecord> {

	private static final List<IMessageBodyHook> hooks = BodyHooks.get();

	public HookMailboxRecordStoreService(BmContext context, Container container,
			IItemValueStore<MailboxRecord> itemValueStore, IItemFlagsProvider<MailboxRecord> fProv,
			IWeightSeedProvider<MailboxRecord> wsProv, IWeightProvider wProv,
			ItemValueAuditLogService<MailboxRecord> logService) {
		super(context, container, itemValueStore, fProv, wsProv, wProv, logService);
	}

	@Override
	protected void beforeCreationInBackupStore(ItemValue<MailboxRecord> itemValue) {
		hooks.forEach(hook -> hook.preCreate(container.domainUid, container.owner, itemValue.value));
	}

	@Override
	protected void preUpdateValue(Item newItem, MailboxRecord newValue, Supplier<MailboxRecord> oldValue)
			throws SQLException {
		MailboxRecord prevRec = oldValue.get();
		if (prevRec == null || !prevRec.messageBody.equals(newValue.messageBody)) {
			hooks.forEach(hook -> hook.preUpdate(container.domainUid, container.owner, newValue));
		}

	}

}
