/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.dto.settings;

public enum SettingsStatus {

	OK(1), PROTOCOL_ERROR(2), ACCESS_DENIED(3), SERVER_UNAVAILABLE(4), INVALID_ARGUMENTS(5), CONFLICTING_ARGUMENTS(6),
	DENIED_BY_POLICY(7);

	private final String xmlValue;

	private SettingsStatus(int value) {
		xmlValue = Integer.toString(value);
	}

	public String xmlValue() {
		return xmlValue;
	}

}
