package net.bluemind.webmodule.project.vite;

import java.net.URI;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

@JsonInclude(Include.NON_NULL)
public class BundleDevConfiguration {

	private URI server;
	private URI defaultURI;
	private boolean enabled;
	
	private BundleDevConfiguration() {
		enabled = false;
	}

	private BundleDevConfiguration(URI uri) {
		this();
		defaultURI = uri;
	}

	public static BundleDevConfiguration defaultConfiguration(URI defaultURI) {
		return new BundleDevConfiguration(defaultURI);
	}

	public boolean isEnabled() {
		return enabled;
	}

	public BundleDevConfiguration setServer(URI server) {
		this.server = server;
		return this;
	}

	public URI getServer() {
		return Optional.ofNullable(server).orElse(defaultURI);
	}

	public BundleDevConfiguration disable() {
		enabled = false;
		return this;
	}

	public BundleDevConfiguration merge(BundleDevConfiguration conf) {
		enabled = conf.enabled;
		server = conf.server;
		return this;
	}

	public BundleDevConfiguration enable() {
		enabled = true;
		return this;
	}

}