/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.delivery.lmtp;

import java.io.IOException;
import java.io.InputStream;

import io.netty.buffer.ByteBuf;
import net.bluemind.memory.pool.api.ChunkFiler;
import net.bluemind.size.helper.MaxMessageSize;

public class MmapRewindStream {

	private final String chunkAddress;

	public MmapRewindStream(InputStream data, int capacity) throws IOException {
		this.chunkAddress = ChunkFiler.newChunkAddress(Math.min(MaxMessageSize.get(), capacity));
		data.transferTo(ChunkFiler.byAddress(chunkAddress).appendStream());
	}

	public ByteBuf byteBuffer() {
		return ChunkFiler.byAddress(chunkAddress).openBuffer();
	}

}
