/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.model.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * https://shipilev.net/jvm-anatomy-park/10-string-intern/
 */
public class CHMInterner {

	private static final CHMInterner IMPL = new CHMInterner();

	public static final CHMInterner get() {
		return IMPL;
	}

	private final Map<String, String> map;

	public CHMInterner() {
		map = new ConcurrentHashMap<>();
	}

	public String intern(String s) {
		if (s == null) {
			return s;
		}
		String exist = map.putIfAbsent(s, s);
		return (exist == null) ? s : exist;
	}
}
