/* BEGIN LICENSE
/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2020
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
/* BEGIN LICENSE
/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2020
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.delivery.smtp.ndr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.columba.ristretto.smtp.SMTPResponse;

/*
250 – This SMTP server response simply means everything went well and your message was delivered to the recipient server.
421 – Your message was temporarily deferred by the recipient server. This is usually a result of too many connections in a short timeframe or too many messages.
450 – Your message was not delivered because the other user mailbox was not available. This can happen if the mailbox is locked or is not routable.
451 – This response is sent when the message simply failed. Often times this is not caused by you, but rather because of a far-end server problem.
452 – This kind of response is sent back when there isn’t enough system storage to send the message. Your message is deferred until storage opens up and it can then be delivered.
550 – The message has failed because the other user’s mailbox is unavailable or because the recipient server rejected your message.
551 – The mailbox your message was intended for does not exist on the recipient server.
552 – The mailbox your message was sent to does not have enough storage to accept your message.
553 – You message was not delivered because the name of the mailbox you sent to does not exist.
554 – This is a very vague message failure response that can refer to any number of problems either on your end or with the recipient server.
 */

public class SendmailResponse {
	private int code;
	private String smtpStatus;
	private String message;
	private String originalFrom;
	private String originalSender;
	private List<FailedRecipient> failedRecipients = new ArrayList<>();
	private int requestedDSNs;
	private InputStream originalMsg;
	private boolean isIOError;

	public SendmailResponse() {
	}

	public SendmailResponse(InputStream originalMsg) {
		this.originalMsg = originalMsg;
	}

	public int getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public String getSmtpStatus() {
		return smtpStatus;
	}

	public String getOriginalFrom() {
		return originalFrom;
	}

	public void setOriginalFrom(String originalFrom) {
		this.originalFrom = originalFrom;
	}

	public String getOriginalSender() {
		return originalSender;
	}

	public void setOriginalSender(String originalSender) {
		this.originalSender = originalSender;
	}

	public boolean isSenderDifferentFrom() {
		return originalSender != null && !originalSender.equalsIgnoreCase(originalFrom);
	}

	public void setOriginalMsg(InputStream originalMsg) {
		this.originalMsg = originalMsg;
	}

	public InputStream getOriginalMsg() {
		return originalMsg;
	}

	public List<FailedRecipient> getFailedRecipients() {
		return failedRecipients;
	}

	public void setFailedRecipients(List<FailedRecipient> failedRecipients) {
		this.failedRecipients = failedRecipients;
	}

	public static SendmailResponse success() {
		SendmailResponse response = new SendmailResponse();
		response.code = 250;
		response.message = "";
		return response;
	}

	public static SendmailResponse failure(String message, String originalFrom) {
		SendmailResponse response = new SendmailResponse();
		response.fail(message, originalFrom, Collections.emptyList());
		return response;
	}

	public static SendmailResponse connectionError(String message) {
		SendmailResponse response = new SendmailResponse();
		response.isIOError = true;
		response.message = message;
		return response;
	}

	public boolean isOk() {
		int majorDigit = Integer.parseInt(Integer.toString(code).substring(0, 1));
		return majorDigit == 2;
	}

	public List<FailedRecipient> getFailedRecipientsInError() {
		return failedRecipients.stream().filter(fr -> fr.isError()).toList();
	}

	public void addFailedRecipient(FailedRecipient failedRecipient) {
		this.failedRecipients.add(failedRecipient);
	}

	public int getRequestedDSNs() {
		return requestedDSNs;
	}

	public void requestDSN() {
		requestedDSNs++;
	}

	public boolean isFailedResponse() {
		return SendmailHelper.isError(code) || hasFailedRecipients();
	}

	public boolean hasFailedRecipients() {
		return !getFailedRecipientsInError().isEmpty();
	}

	public void success(SMTPResponse smtpResponse, String originalFrom, List<FailedRecipient> failedRecipients) {
		this.code = smtpResponse.getCode();
		this.message = smtpResponse.getMessage();
		this.originalFrom = originalFrom;
		this.failedRecipients = failedRecipients;
	}

	public void success(SMTPResponse smtpResponse, String originalFrom, List<FailedRecipient> failedRecipients,
			int requestedDSNs) {
		this.code = smtpResponse.getCode();
		this.message = smtpResponse.getMessage();
		this.originalFrom = originalFrom;
		this.failedRecipients = failedRecipients;
		this.requestedDSNs = requestedDSNs;
	}

	public void fail(SMTPResponse smtpResponse, String originalFrom, List<FailedRecipient> failedRecipients,
			String smtpStatus) {
		this.code = smtpResponse.getCode();
		this.message = smtpResponse.getMessage();
		this.originalFrom = originalFrom;
		this.failedRecipients = failedRecipients;
		this.smtpStatus = smtpStatus;
	}

	public void fail(String message, String originalFrom, List<FailedRecipient> failedRecipients) {
		this.code = 500;
		this.message = message;
		this.originalFrom = originalFrom;
		this.failedRecipients = failedRecipients;
		this.smtpStatus = SendmailHelper.SMTP_ERROR_STATUS;
	}

	@Override
	public String toString() {
		StringBuilder res = new StringBuilder();
		res.append(String.format("%d: %s", code, message));
		if (!getFailedRecipientsInError().isEmpty()) {
			res.append("\r\nError for following recipient(s): ");
			for (int i = 0; i < failedRecipients.size(); i++) {
				res.append("\r\n" + failedRecipients.get(i));
			}
		}
		res.append(String.format("\r%n Requested DSN: %d", requestedDSNs));
		res.append(String.format("\r%n Smtp Error Code: %s", smtpStatus));
		return res.toString();
	}

	public boolean isIOError() {
		return this.isIOError;
	}

}
