package net.bluemind.metrics.registry.client;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.LongAdder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonProcessingException;

import net.bluemind.metrics.registry.impl.Mapper;
import net.bluemind.metrics.registry.json.RegJson;

public class AgentPushClient {

	private ArrayBlockingQueue<byte[]> queue;
	private static final Logger logger = LoggerFactory.getLogger(AgentPushClient.class);

	private LongAdder dropped = new LongAdder();

	public AgentPushClient(ArrayBlockingQueue<byte[]> sharedQueue) {
		this.queue = sharedQueue;
	}

	public void queue(RegJson dto) {
		try {
			byte[] chunk = Mapper.get().writeValueAsBytes(dto);
			boolean accepted = queue.offer(chunk);
			if (!accepted) {
				dropped.increment();
				long totalDrops = dropped.sum();
				if (totalDrops % 100 == 0) {
					logger.warn("Metrics dropped {}", totalDrops);
				}
			}
		} catch (JsonProcessingException e) {
			logger.error(e.getMessage(), e);
		}

	}
}
