import Vue2TouchEvents from "vue2-touch-events";

import { createPinia } from "pinia";

import { DefaultAlert } from "@bluemind/alert.store";

import { Bluetiful } from "@bluemind/bluetiful";
import Command from "@bluemind/command";
import app from "@bluemind/global.app";

import store from "@bluemind/store";
import VueBus from "@bluemind/vue-bus";
import VueSockjsPlugin from "@bluemind/vue-sockjs";

import MainApp from "./components/MainApp";

import { ClientStateObserverModule } from "./modules/ClientStateObserverModule";
import { ContainerObserverModule } from "./modules/ContainerObserverModule";
import { InjectPersistanceDependenciesModule } from "./modules/InjectPersistanceDependenciesModule";
import { NotificationModule } from "./modules/NotificationModule";
import { RouterModule } from "./modules/RouterModule";
import { ServiceWorkerModule } from "./modules/ServiceWorkerModule";
import { SessionModule } from "./modules/SessionModule";
import { StoreModule } from "./modules/StoreModule";
import { TranslationModule } from "./modules/TranslationModule";

// FEATBOOK-114
window["bundles"]["net.bluemind.webapp.root.js"]["start"] = () => {
    const userSession = window.bmcSessionInfos;
    app.use(ServiceWorkerModule);
    app.use(SessionModule, { userSession });
    app.use(InjectPersistanceDependenciesModule, { userSession });
    app.use(StoreModule);
    app.use(VueBus, store);
    app.use(NotificationModule);
    app.use(Bluetiful, { lang: userSession.lang });
    app.use(RouterModule);
    app.use(TranslationModule, { userSession });
    app.use(createPinia());
    app.use(ClientStateObserverModule);
    app.use(ContainerObserverModule);
    if (userSession.userId) {
        app.use(VueSockjsPlugin, { VueBus });
    }
    app.use(Vue2TouchEvents, { disableClick: true });
    app.use(Command);
    app.component("DefaultAlert", DefaultAlert);
    app.component("MainApp", MainApp);
    app.mount("#app");
};
