import { ComponentOptions, defineComponent, h, markRaw } from "vue";

import { getDefaultAlertService } from "@bluemind/alert.store";
import { AlertTypes } from "@bluemind/bluetiful";

import UUIDGenerator from "@bluemind/uuid";

export default function EmbeddedAppWrapper(name: string, url: string) {
    return {
        extends: WrapperComponent,
        name,
        data: () => ({ url })
    };
}
const WrapperComponent: ComponentOptions = {
    name: "EmbeddedAppWrapper",
    render() {
        return h("iframe", {
            src: this.src,
            onLoad: this.forwardNotice,
            class: "flex-fill",
            style: { border: "none", backgroundColor: "white" }
        });
    },
    computed: {
        src() {
            const url = new URL(this.url, document.baseURI);
            for (const param in this.$route.query) {
                url.searchParams.set(param, this.$route.query[param]);
            }
            url.hash = this.$route.hash;
            return url.toString();
        }
    },
    methods: {
        forwardNotice() {
            const { dispatchAlert } = getDefaultAlertService();
            this.$el.contentDocument.addEventListener("ui-notification", (e: CustomEvent) => {
                const type = e.detail?.type !== "error" ? AlertTypes.SUCCESS : AlertTypes.ERROR;
                dispatchAlert({
                    uid: UUIDGenerator.generate(),
                    renderer: {
                        component: markRaw(EmbeddedNotificationAlert),
                        props: { payload: e.detail?.message }
                    },
                    type
                });
            });
        }
    }
};
const EmbeddedNotificationAlert = defineComponent({
    name: "EmbeddedNotificationAlert",
    props: {
        payload: {
            type: Object,
            default: () => ({})
        }
    },
    render() {
        return h("span", this.payload);
    }
});
