import { mapExtensions } from "@bluemind/extensions";
import Roles from "@bluemind/roles";

export default function (vueI18N) {
    const calendar = mapExtensions("net.bluemind.webapp", ["application"]).application?.find(
        ({ $bundle }) => $bundle === "net.bluemind.webmodules.calendar"
    );

    return {
        name: vueI18N.t("common.application.calendar"),
        id: "calendar",
        icon: calendar?.icon,
        priority: calendar?.priority,
        visible: { name: "RoleCondition", args: [Roles.HAS_CALENDAR] },
        categories: [mainCategory(vueI18N), myCalendarsCategory(vueI18N), otherCalendarsCategory(vueI18N)]
    };
}

function mainCategory(vueI18N) {
    return {
        id: "main",
        name: vueI18N.t("common.general"),
        icon: "tool",
        groups: [
            {
                id: "view",
                name: vueI18N.t("preferences.calendar.main.configure_view"),
                fields: [
                    {
                        id: "day_weekstart",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                setting: "day_weekstart",
                                needReload: true,
                                label: vueI18N.t("preferences.calendar.main.week_starts_on"),
                                choices: [
                                    { text: vueI18N.t("common.monday"), value: "monday" },
                                    { text: vueI18N.t("common.sunday"), value: "sunday" }
                                ]
                            }
                        }
                    },
                    {
                        id: "defaultview",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                setting: "defaultview",
                                label: vueI18N.t("preferences.calendar.main.default_view"),
                                choices: [
                                    { text: vueI18N.t("common.day"), value: "day" },
                                    { text: vueI18N.t("common.week"), value: "week" },
                                    { text: vueI18N.t("common.month"), value: "month" },
                                    { text: vueI18N.t("common.list"), value: "agenda" }
                                ]
                            }
                        }
                    },
                    {
                        id: "showweekends",
                        component: {
                            name: "PrefFieldCheck",
                            options: {
                                setting: "showweekends",
                                needReload: true,
                                label: vueI18N.t("preferences.calendar.main.show_weekends")
                            }
                        }
                    },
                    {
                        id: "workhours",
                        component: { name: "PrefWorkHours", options: { needReload: true } }
                    },
                    {
                        id: "show_declined_events",
                        component: {
                            name: "PrefFieldCheck",
                            options: {
                                setting: "show_declined_events",
                                needReload: true,
                                label: vueI18N.t("preferences.calendar.main.show_declined_events")
                            }
                        }
                    },
                    {
                        id: "working_days",
                        component: {
                            name: "PrefWorkingDays",
                            options: {
                                setting: "working_days",
                                needReload: true,
                                choices: [
                                    { value: "mon", text: vueI18N.t("common.monday_short") },
                                    { value: "tue", text: vueI18N.t("common.tuesday_short") },
                                    { value: "wed", text: vueI18N.t("common.wednesday_short") },
                                    { value: "thu", text: vueI18N.t("common.thursday_short") },
                                    { value: "fri", text: vueI18N.t("common.friday_short") },
                                    { value: "sat", text: vueI18N.t("common.saturday_short") },
                                    { value: "sun", text: vueI18N.t("common.sunday_short") }
                                ]
                            }
                        }
                    }
                ]
            },
            {
                id: "reminders",
                name: vueI18N.t("preferences.calendar.main.reminders"),
                fields: [
                    {
                        id: "default",
                        component: {
                            name: "PrefEventReminder",
                            options: { setting: "default_event_alert", needReload: true }
                        }
                    },
                    {
                        id: "default_allday",
                        component: {
                            name: "PrefAllDayEventReminder",
                            options: { setting: "default_allday_event_alert", needReload: true }
                        }
                    },
                    {
                        id: "default_mode",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                setting: "default_event_alert_mode",
                                default: "Display",
                                label: vueI18N.t("preferences.calendar.main.default_reminder_kind"),
                                needReload: true,
                                choices: [
                                    { text: vueI18N.t("common.email"), value: "Email" },
                                    { text: vueI18N.t("common.notification"), value: "Display" }
                                ]
                            }
                        }
                    }
                ]
            }
        ]
    };
}

function myCalendarsCategory(vueI18N) {
    return {
        id: "my_calendars",
        name: vueI18N.t("common.my_calendars"),
        icon: "calendar-user",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.my_calendars"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefManageMyCalendars" },
                        keywords: [vueI18N.t("preferences.calendar.my_calendars.availabilities_management")]
                    }
                ]
            }
        ]
    };
}

function otherCalendarsCategory(vueI18N) {
    return {
        id: "other_calendars",
        name: vueI18N.t("common.other_calendars"),
        icon: "calendar-3dots",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.other_calendars"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefManageOtherCalendars" }
                    }
                ]
            }
        ]
    };
}
