import { markRaw } from "vue";

import { DefaultAlert } from "@bluemind/alert.store";
import { AlertTypes, DispatchAlertMixin, useDispatchAlert } from "@bluemind/bluetiful";
import store from "@bluemind/store";

export default {
    mixins: [DispatchAlertMixin],
    methods: {
        save(options) {
            const action = options?.auto ? "AUTOSAVE" : "SAVE";
            return execute(this.dispatchAlert, action);
        }
    }
};

export function useSave() {
    const { dispatchAlert } = useDispatchAlert();
    return {
        save: options => execute(dispatchAlert, options?.auto ? "AUTOSAVE" : "SAVE")
    };
}

async function execute(dispatchAlert, actionName) {
    const uid = "save_uid";
    const name = "preferences.save";
    const component = markRaw(DefaultAlert);
    try {
        const result = await store.dispatch(`preferences/fields/${actionName}`);
        dispatchAlert?.({ uid, type: AlertTypes.SUCCESS, renderer: { component, props: { name, result } } });
        return result;
    } catch (e) {
        dispatchAlert({
            uid,
            type: AlertTypes.ERROR,
            renderer: { component, props: { name, error: e } }
        });
        throw e;
    }
}
