/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.backend.mail.api.FolderCounters;
import net.bluemind.backend.mail.replica.api.AppendTx;
import net.bluemind.backend.mail.replica.api.MailboxReplica;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.repository.IItemValueStore;

public interface IMailboxReplicaStore extends IItemValueStore<MailboxReplica> {

	void create(Item item, MailboxReplica value) throws SQLException;

	void update(Item item, MailboxReplica value) throws SQLException;

	void delete(Item item) throws SQLException;

	MailboxReplica get(Item item) throws SQLException;

	void deleteAll() throws SQLException;

	String byName(String name) throws SQLException;

	AppendTx prepareAppend(int count, long mboxReplicaId) throws SQLException;

	List<Long> childrensOf(String folderUid) throws SQLException;

	boolean exists(Item item) throws SQLException;

	List<FolderCounters> counters(List<Long> folderItemIds) throws SQLException;

}
