package net.bluemind.eas.http.wbxml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.io.ByteSource;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import net.bluemind.eas.http.AuthorizedDeviceQuery;
import net.bluemind.memory.pool.api.CommonMemoryPool;
import net.bluemind.memory.pool.api.IWritableChunk;
import net.bluemind.size.helper.MaxMessageSize;
import net.bluemind.vertx.common.request.Requests;

public class StreamConsumer implements Handler<Buffer> {

	private static final Logger logger = LoggerFactory.getLogger(StreamConsumer.class);

	private final IWritableChunk chunk;
	private final AuthorizedDeviceQuery query;

	private static final Cleaner chunksCleaner = Cleaner.create(Thread.ofVirtual().factory());

	public StreamConsumer(AuthorizedDeviceQuery query) {
		try {
			this.chunk = CommonMemoryPool.getDefault().allocateEmpty(MaxMessageSize.get());
			chunksCleaner.register(this, chunk::release);
		} catch (IOException e) {
			throw new UnsupportedOperationException(e);
		}
		this.query = query;
	}

	public ByteSource inputStream() throws IOException {
		return new ByteSource() {

			@Override
			public InputStream openStream() throws IOException {
				return chunk.openStream();
			}
		};
	}

	public boolean isEmptyRequestBody() {
		return chunk.getSize() == 0;
	}

	@Override
	public void handle(Buffer event) {
		chunk.append(((BufferImpl) event).getByteBuf());
	}

	public void markEnd() {
		Requests.tag(query.request(), "in.size", chunk.getSize() + "b");
	}

	public void dispose() {
		chunk.release();
	}

}