/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlContainerStore;
import net.bluemind.core.container.cql.store.CqlUserSubscription;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;
import net.bluemind.user.repository.IUserSubscriptionStore;

public class UserSubscriptionStoreFactory extends CqlRepositoryFactory<IUserSubscriptionStore>
		implements IContainerBoundFactory<IUserSubscriptionStore> {

	@Override
	public Class<IUserSubscriptionStore> factoryClass() {
		return IUserSubscriptionStore.class;
	}

	@Override
	public IUserSubscriptionStore instance(BmContext context, Container container) throws ServerFault {
		CqlContainerStore cont = new CqlContainerStore(CqlSessions.forKeyspace("core"), SequenceStores.getDefault(),
				context.getSecurityContext());
		return new CqlUserSubscription(CqlSessions.forKeyspace("core"), cont);
	}

}
