/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlItemStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.repository.IItemStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class ItemStoreFactory extends CqlRepositoryFactory<IItemStore> implements IContainerBoundFactory<IItemStore> {

	@Override
	public Class<IItemStore> factoryClass() {
		return IItemStore.class;
	}

	@Override
	public IItemStore instance(BmContext context, Container container) throws ServerFault {
		return new CqlItemStore(container, CqlSessions.forKeyspace("core"), SequenceStores.getDefault(),
				context.getSecurityContext());
	}

}
