/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.repository.IContainerSettingsStore;
import net.bluemind.cql.persistence.CqlAbstractStore;

public class CqlSettingsStore extends CqlAbstractStore implements IContainerSettingsStore {

	private final String uid;

	public CqlSettingsStore(CqlSession s, Container c) {
		super(s);
		this.uid = c.uid;
	}

	@Override
	public Map<String, String> getSettings() {
		return unique("SELECT settings FROM t_container WHERE uid = ?", r -> r.getMap(0, String.class, String.class),
				voidPop(), uid);
	}

	@Override
	public void setSettings(Map<String, String> settings) throws SQLException {
		voidCql("UPDATE t_container SET settings = ? WHERE uid = ?", settings, uid);
	}

	@Override
	public void mutateSettings(Map<String, String> mutatedValues) throws SQLException {
		voidCql("UPDATE t_container SET settings = settings + ? WHERE uid = ?", mutatedValues, uid);
	}

	@Override
	public void delete() throws SQLException {
		setSettings(Collections.emptyMap());
	}

}
