/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store;

import java.sql.SQLException;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.api.ContainerSubscriptionModel;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.repository.IOwnerSubscriptionStore;
import net.bluemind.cql.persistence.CqlAbstractStore;

public class CqlOwnerSubsStore extends CqlAbstractStore implements IOwnerSubscriptionStore {

	private final long subId;

	public CqlOwnerSubsStore(CqlSession s, Container subs) {
		super(s);
		this.subId = subs.id;
	}

	@Override
	public void create(Item item, ContainerSubscriptionModel value) throws SQLException {
		voidCql("update t_owner_subs set uid=?, type=?, owner=?, automount=? where container_id=? and item_id=?",
				value.containerUid, value.containerType, value.owner, value.automount, subId, item.id);
	}

	@Override
	public void update(Item item, ContainerSubscriptionModel value) throws SQLException {
		create(item, value);
	}

	@Override
	public void delete(Item item) throws SQLException {
		voidCql("delete from t_owner_subs where container_id=? and item_id=?", item.id);
	}

	@Override
	public ContainerSubscriptionModel get(Item item) throws SQLException {
		return unique("select uid, type, owner, automount from t_owner_subs where container_id=? and item_id=?", r -> {
			ContainerSubscriptionModel mdl = new ContainerSubscriptionModel();
			mdl.containerUid = r.getString(0);
			mdl.containerType = r.getString(1);
			mdl.owner = r.getString(2);
			mdl.automount = r.getBoolean(3);
			return mdl;
		}, voidPop(), subId, item.id);
	}

	@Override
	public void deleteAll() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean exists(Item item) throws SQLException {
		return unique("select item_id from t_owner_subs where container_id=? and item_id=?", r -> r.getLong(0),
				voidPop(), subId, item.id) != null;
	}

}
