/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store;

import java.sql.SQLException;

import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerRouteStore;

public final class CqlContainerRouteStore implements IContainerRouteStore {

	private static final DataLocation SCYLLA = DataLocation.of("scylladb");

	@Override
	public DataLocation routeOf(ContainerUid cUid) {
		return SCYLLA;
	}

	@Override
	public void storeRoute(ContainerUid cUid, DataLocation route) throws SQLException {
	}

	@Override
	public void deleteRoute(ContainerUid cUid) throws SQLException {
	}

}
