/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2020
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.lib.ical4j.vcard;

import net.bluemind.lib.ical4j.vcard.property.AddressbookServerKind;
import net.bluemind.lib.ical4j.vcard.property.AddressbookServerMember;
import net.bluemind.lib.ical4j.vcard.property.NoteAsHtml;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.vcard.Property.Id;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.Agent;
import net.fortuna.ical4j.vcard.property.BMBDay;
import net.fortuna.ical4j.vcard.property.Birth;
import net.fortuna.ical4j.vcard.property.CalAdrUri;
import net.fortuna.ical4j.vcard.property.CalUri;
import net.fortuna.ical4j.vcard.property.Categories;
import net.fortuna.ical4j.vcard.property.Clazz;
import net.fortuna.ical4j.vcard.property.DDay;
import net.fortuna.ical4j.vcard.property.Death;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.FbUrl;
import net.fortuna.ical4j.vcard.property.Fn;
import net.fortuna.ical4j.vcard.property.Gender;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Impp;
import net.fortuna.ical4j.vcard.property.Key;
import net.fortuna.ical4j.vcard.property.Kind;
import net.fortuna.ical4j.vcard.property.Label;
import net.fortuna.ical4j.vcard.property.Lang;
import net.fortuna.ical4j.vcard.property.Logo;
import net.fortuna.ical4j.vcard.property.Mailer;
import net.fortuna.ical4j.vcard.property.Member;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Name;
import net.fortuna.ical4j.vcard.property.Nickname;
import net.fortuna.ical4j.vcard.property.Note;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Photo;
import net.fortuna.ical4j.vcard.property.ProdId;
import net.fortuna.ical4j.vcard.property.Related;
import net.fortuna.ical4j.vcard.property.Revision;
import net.fortuna.ical4j.vcard.property.Role;
import net.fortuna.ical4j.vcard.property.SortString;
import net.fortuna.ical4j.vcard.property.Sound;
import net.fortuna.ical4j.vcard.property.Source;
import net.fortuna.ical4j.vcard.property.Telephone;
import net.fortuna.ical4j.vcard.property.Title;
import net.fortuna.ical4j.vcard.property.Tz;
import net.fortuna.ical4j.vcard.property.Uid;
import net.fortuna.ical4j.vcard.property.Url;
import net.fortuna.ical4j.vcard.property.Version;

public class BmPropertyFactoryRegistry extends PropertyFactoryRegistry {

	public BmPropertyFactoryRegistry() {
		super();

		super.register("X-ADDRESSBOOKSERVER-KIND", AddressbookServerKind.FACTORY);
		super.register("X-ADDRESSBOOKSERVER-MEMBER", AddressbookServerMember.FACTORY);
		super.register("X-NOTE-HTML", NoteAsHtml.FACTORY);

		super.register(Id.ADR.getPropertyName(), new Address.Factory());
		super.register(Id.AGENT.getPropertyName(), new Agent.Factory());
		super.register(Id.BDAY.getPropertyName(), BMBDay.FACTORY);
		super.register(Id.BIRTH.getPropertyName(), new Birth.Factory());
		super.register(Id.CALADRURI.getPropertyName(), new CalAdrUri.Factory());
		super.register(Id.CALURI.getPropertyName(), new CalUri.Factory());
		super.register(Id.CATEGORIES.getPropertyName(), new Categories.Factory());
		super.register(Id.CLASS.getPropertyName(), new Clazz.Factory());
		super.register(Id.DDAY.getPropertyName(), new DDay.Factory());
		super.register(Id.DEATH.getPropertyName(), new Death.Factory());
		super.register(Id.EMAIL.getPropertyName(), new Email.Factory());
		super.register(Id.FBURL.getPropertyName(), new FbUrl.Factory());
		super.register(Id.FN.getPropertyName(), new Fn.Factory());
		super.register(Id.GENDER.getPropertyName(), new Gender.Factory());
		super.register(Id.GEO.getPropertyName(), new Geo.Factory());
		super.register(Id.IMPP.getPropertyName(), new Impp.Factory());
		super.register(Id.KEY.getPropertyName(), new Key.Factory());
		super.register(Id.KIND.getPropertyName(), new Kind.Factory());
		super.register(Id.LABEL.getPropertyName(), new Label.Factory());
		super.register(Id.LANG.getPropertyName(), new Lang.Factory());
		super.register(Id.LOGO.getPropertyName(), new Logo.Factory());
		super.register(Id.MAILER.getPropertyName(), new Mailer.Factory());
		super.register(Id.MEMBER.getPropertyName(), new Member.Factory());
		super.register(Id.N.getPropertyName(), new N.Factory());
		super.register(Id.NAME.getPropertyName(), new Name.Factory());
		super.register(Id.NICKNAME.getPropertyName(), new Nickname.Factory());
		super.register(Id.NOTE.getPropertyName(), new Note.Factory());
		super.register(Id.ORG.getPropertyName(), new Org.Factory());
		super.register(Id.PHOTO.getPropertyName(), new Photo.Factory());
		super.register(Id.PRODID.getPropertyName(), new ProdId.Factory());
		super.register(Id.RELATED.getPropertyName(), new Related.Factory());
		super.register(Id.REV.getPropertyName(), new Revision.Factory());
		super.register(Id.ROLE.getPropertyName(), new Role.Factory());
		super.register(Id.SORT_STRING.getPropertyName(), new SortString.Factory());
		super.register(Id.SOUND.getPropertyName(), new Sound.Factory());
		super.register(Id.SOURCE.getPropertyName(), new Source.Factory());
		super.register(Id.TEL.getPropertyName(), new Telephone.Factory());
		super.register(Id.TITLE.getPropertyName(), new Title.Factory());
		super.register(Id.TZ.getPropertyName(), new Tz.Factory());
		super.register(Id.UID.getPropertyName(), new Uid.Factory());
		super.register(Id.URL.getPropertyName(), new Url.Factory());
		super.register(Id.VERSION.getPropertyName(), new Version.Factory());
	}

	@Override
	protected boolean factorySupports(PropertyFactory factory, String name) {
		switch (name) {
		case Property.URL:
		case "BDAY":
			return false;
		default:
			return factory.supports(name.toUpperCase());
		}
	}
}
