/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardIdentificationNameGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Identification.Name> {

	private net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer parent = new  net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer();
	public VCardIdentificationNameGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Identification.Name deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Identification.Name ret = new net.bluemind.addressbook.api.VCard.Identification.Name();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Identification.Name ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue familyNamesJSON = json.get("familyNames");
		ret.familyNames =  GwtSerDerUtils.STRING.deserialize(familyNamesJSON);
		JSONValue givenNamesJSON = json.get("givenNames");
		ret.givenNames =  GwtSerDerUtils.STRING.deserialize(givenNamesJSON);
		JSONValue additionalNamesJSON = json.get("additionalNames");
		ret.additionalNames =  GwtSerDerUtils.STRING.deserialize(additionalNamesJSON);
		JSONValue prefixesJSON = json.get("prefixes");
		ret.prefixes =  GwtSerDerUtils.STRING.deserialize(prefixesJSON);
		JSONValue suffixesJSON = json.get("suffixes");
		ret.suffixes =  GwtSerDerUtils.STRING.deserialize(suffixesJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Identification.Name ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("familyNames")) {
			JSONValue familyNamesJSON = json.get("familyNames");
			ret.familyNames =  GwtSerDerUtils.STRING.deserialize(familyNamesJSON);
		}
		if (!childPropertiesToIgnore.contains("givenNames")) {
			JSONValue givenNamesJSON = json.get("givenNames");
			ret.givenNames =  GwtSerDerUtils.STRING.deserialize(givenNamesJSON);
		}
		if (!childPropertiesToIgnore.contains("additionalNames")) {
			JSONValue additionalNamesJSON = json.get("additionalNames");
			ret.additionalNames =  GwtSerDerUtils.STRING.deserialize(additionalNamesJSON);
		}
		if (!childPropertiesToIgnore.contains("prefixes")) {
			JSONValue prefixesJSON = json.get("prefixes");
			ret.prefixes =  GwtSerDerUtils.STRING.deserialize(prefixesJSON);
		}
		if (!childPropertiesToIgnore.contains("suffixes")) {
			JSONValue suffixesJSON = json.get("suffixes");
			ret.suffixes =  GwtSerDerUtils.STRING.deserialize(suffixesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Identification.Name o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Identification.Name o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("familyNames",  GwtSerDerUtils.STRING.serialize( o.familyNames ));
		ret.put("givenNames",  GwtSerDerUtils.STRING.serialize( o.givenNames ));
		ret.put("additionalNames",  GwtSerDerUtils.STRING.serialize( o.additionalNames ));
		ret.put("prefixes",  GwtSerDerUtils.STRING.serialize( o.prefixes ));
		ret.put("suffixes",  GwtSerDerUtils.STRING.serialize( o.suffixes ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Identification.Name o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("familyNames")) {
			ret.put("familyNames",  GwtSerDerUtils.STRING.serialize( o.familyNames ));
		}
		if (!childPropertiesToIgnore.contains("givenNames")) {
			ret.put("givenNames",  GwtSerDerUtils.STRING.serialize( o.givenNames ));
		}
		if (!childPropertiesToIgnore.contains("additionalNames")) {
			ret.put("additionalNames",  GwtSerDerUtils.STRING.serialize( o.additionalNames ));
		}
		if (!childPropertiesToIgnore.contains("prefixes")) {
			ret.put("prefixes",  GwtSerDerUtils.STRING.serialize( o.prefixes ));
		}
		if (!childPropertiesToIgnore.contains("suffixes")) {
			ret.put("suffixes",  GwtSerDerUtils.STRING.serialize( o.suffixes ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}