/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class AddressBooksGwtEndpoint implements net.bluemind.addressbook.api.IAddressBooksAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public AddressBooksGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/addressbooks";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public AddressBooksGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void findCertsByEmail(String email, final AsyncHandler<List<net.bluemind.addressbook.api.CertInfo>> handler) {
		String postUri = "/_findCertsByEmail";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&email=" + URL.encodeQueryString(""+email);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.addressbook.api.CertInfo>>(handler) {
			@Override
			protected List<net.bluemind.addressbook.api.CertInfo> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.CertInfoGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void findUidsByEmail(String email, final AsyncHandler<List<String>> handler) {
		String postUri = "/_findUidsByEmail";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( email);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void search(net.bluemind.addressbook.api.VCardQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.addressbook.api.gwt.serder.VCardQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardInfoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.addressbook.api.IAddressBooksPromise promiseApi() {
		return new AddressBooksEndpointPromise(this);
	}
}
