/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class LogEntryGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.LogEntry> {

	public LogEntryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.LogEntry deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.LogEntry ret = new net.bluemind.scheduledjob.api.LogEntry();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.LogEntry ret, JSONObject json) {
		JSONValue timestampJSON = json.get("timestamp");
		ret.timestamp =  GwtSerDerUtils.LONG.deserialize(timestampJSON);
		JSONValue severityJSON = json.get("severity");
		ret.severity =  new net.bluemind.scheduledjob.api.gwt.serder.LogLevelGwtSerDer().deserialize(severityJSON);
		JSONValue localeJSON = json.get("locale");
		ret.locale =  GwtSerDerUtils.STRING.deserialize(localeJSON);
		JSONValue contentJSON = json.get("content");
		ret.content =  GwtSerDerUtils.STRING.deserialize(contentJSON);
		JSONValue offsetJSON = json.get("offset");
		ret.offset =  GwtSerDerUtils.INT.deserialize(offsetJSON);
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.LogEntry ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("timestamp")) {
			JSONValue timestampJSON = json.get("timestamp");
			ret.timestamp =  GwtSerDerUtils.LONG.deserialize(timestampJSON);
		}
		if (!childPropertiesToIgnore.contains("severity")) {
			JSONValue severityJSON = json.get("severity");
			ret.severity =  new net.bluemind.scheduledjob.api.gwt.serder.LogLevelGwtSerDer().deserialize(severityJSON);
		}
		if (!childPropertiesToIgnore.contains("locale")) {
			JSONValue localeJSON = json.get("locale");
			ret.locale =  GwtSerDerUtils.STRING.deserialize(localeJSON);
		}
		if (!childPropertiesToIgnore.contains("content")) {
			JSONValue contentJSON = json.get("content");
			ret.content =  GwtSerDerUtils.STRING.deserialize(contentJSON);
		}
		if (!childPropertiesToIgnore.contains("offset")) {
			JSONValue offsetJSON = json.get("offset");
			ret.offset =  GwtSerDerUtils.INT.deserialize(offsetJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.LogEntry o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.LogEntry o, JSONObject ret) {

		ret.put("timestamp",  GwtSerDerUtils.LONG.serialize( o.timestamp ));
		ret.put("severity",  new net.bluemind.scheduledjob.api.gwt.serder.LogLevelGwtSerDer().serialize( o.severity ));
		ret.put("locale",  GwtSerDerUtils.STRING.serialize( o.locale ));
		ret.put("content",  GwtSerDerUtils.STRING.serialize( o.content ));
		ret.put("offset",  GwtSerDerUtils.INT.serialize( o.offset ));
	}

	public void serializeTo(net.bluemind.scheduledjob.api.LogEntry o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("timestamp")) {
			ret.put("timestamp",  GwtSerDerUtils.LONG.serialize( o.timestamp ));
		}
		if (!childPropertiesToIgnore.contains("severity")) {
			ret.put("severity",  new net.bluemind.scheduledjob.api.gwt.serder.LogLevelGwtSerDer().serialize( o.severity ));
		}
		if (!childPropertiesToIgnore.contains("locale")) {
			ret.put("locale",  GwtSerDerUtils.STRING.serialize( o.locale ));
		}
		if (!childPropertiesToIgnore.contains("content")) {
			ret.put("content",  GwtSerDerUtils.STRING.serialize( o.content ));
		}
		if (!childPropertiesToIgnore.contains("offset")) {
			ret.put("offset",  GwtSerDerUtils.INT.serialize( o.offset ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}