/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.scheduledjob.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsPlanKind extends JavaScriptObject {

	protected JsPlanKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsPlanKind OPPORTUNISTIC()
	/*-{
		return "OPPORTUNISTIC";
	}-*/;

	public static final native JsPlanKind SCHEDULED()
	/*-{
		return "SCHEDULED";
	}-*/;

	public static final native JsPlanKind DISABLED()
	/*-{
		return "DISABLED";
	}-*/;

	public static final JsPlanKind create(net.bluemind.scheduledjob.api.PlanKind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case OPPORTUNISTIC:
				return OPPORTUNISTIC();
			case SCHEDULED:
				return SCHEDULED();
			case DISABLED:
				return DISABLED();
			default:
				return null;
			}
		}
	}
}