package net.bluemind.webmodule.server.resources;

import java.nio.file.Files;

import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


class StaticWebResource extends AbstractWebResource implements WebResource {
	private static final Logger logger = LoggerFactory.getLogger(StaticWebResource.class);

	public StaticWebResource(Bundle bundle) {
		super(bundle);
		if (root.isPresent()) {
			preload();
		}
	}

	private void preload() {
		findFilesInBundle("*", root.get()).stream().filter(Files::isRegularFile).forEach(this::load);
		logger.info("statics for bundle {} : {}", getBundleName(), getResources());
	}

}
