/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InternalBMFileSystemEndpointPromise implements net.bluemind.filehosting.api.IInternalBMFileSystemPromise {

	private net.bluemind.filehosting.api.IInternalBMFileSystemAsync impl;

	public InternalBMFileSystemEndpointPromise(net.bluemind.filehosting.api.IInternalBMFileSystemAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> delete(String path  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> exists(String path  ) {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.exists(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>> find(String query  ) {
		
		CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>> ret = new CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>>();
		AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler = new AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>>() {
			public void success(List<net.bluemind.filehosting.api.FileHostingItem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.find(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> get(String path  ) {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.filehosting.api.FileHostingItem> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.filehosting.api.FileHostingItem> ret = new CompletableFuture<net.bluemind.filehosting.api.FileHostingItem>();
		AsyncHandler<net.bluemind.filehosting.api.FileHostingItem> handler = new AsyncHandler<net.bluemind.filehosting.api.FileHostingItem>() {
			public void success(net.bluemind.filehosting.api.FileHostingItem value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.filehosting.api.Configuration> getConfiguration() {
		
		CompletableFuture<net.bluemind.filehosting.api.Configuration> ret = new CompletableFuture<net.bluemind.filehosting.api.Configuration>();
		AsyncHandler<net.bluemind.filehosting.api.Configuration> handler = new AsyncHandler<net.bluemind.filehosting.api.Configuration>() {
			public void success(net.bluemind.filehosting.api.Configuration value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getConfiguration( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> getShareUidsByPath(String path  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getShareUidsByPath(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> getSharedFile(String uid  ) {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSharedFile(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.filehosting.api.FileHostingInfo> info() {
		
		CompletableFuture<net.bluemind.filehosting.api.FileHostingInfo> ret = new CompletableFuture<net.bluemind.filehosting.api.FileHostingInfo>();
		AsyncHandler<net.bluemind.filehosting.api.FileHostingInfo> handler = new AsyncHandler<net.bluemind.filehosting.api.FileHostingInfo>() {
			public void success(net.bluemind.filehosting.api.FileHostingInfo value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.info( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>> list(String path  ) {
		
		CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>> ret = new CompletableFuture<List<net.bluemind.filehosting.api.FileHostingItem>>();
		AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler = new AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>>() {
			public void success(List<net.bluemind.filehosting.api.FileHostingItem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list(path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink> share(String path ,  Integer downloadLimit ,  String expirationDate  ) {
		
		CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink> ret = new CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink>();
		AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink> handler = new AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink>() {
			public void success(net.bluemind.filehosting.api.FileHostingPublicLink value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.share(path, downloadLimit, expirationDate,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> store(String path ,  Stream document  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.store(path, document,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink> storeAndShare(String path ,  Integer downloadLimit ,  String expirationDate ,  Stream document  ) {
		
		CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink> ret = new CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink>();
		AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink> handler = new AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink>() {
			public void success(net.bluemind.filehosting.api.FileHostingPublicLink value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.storeAndShare(path, downloadLimit, expirationDate, document,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unShare(String url  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unShare(url,  handler);
		return ret;
	}

}
