/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.attachment.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ConfigurationGwtSerDer implements GwtSerDer<net.bluemind.attachment.api.Configuration> {

	public ConfigurationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.attachment.api.Configuration deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.attachment.api.Configuration ret = new net.bluemind.attachment.api.Configuration();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.attachment.api.Configuration ret, JSONObject json) {
		JSONValue autoDetachmentLimitJSON = json.get("autoDetachmentLimit");
		ret.autoDetachmentLimit =  GwtSerDerUtils.LONG.deserialize(autoDetachmentLimitJSON);
		JSONValue maxFilesizeJSON = json.get("maxFilesize");
		ret.maxFilesize =  GwtSerDerUtils.LONG.deserialize(maxFilesizeJSON);
		JSONValue retentionTimeJSON = json.get("retentionTime");
		ret.retentionTime =  GwtSerDerUtils.INT.deserialize(retentionTimeJSON);
	}

	public void deserializeTo(net.bluemind.attachment.api.Configuration ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("autoDetachmentLimit")) {
			JSONValue autoDetachmentLimitJSON = json.get("autoDetachmentLimit");
			ret.autoDetachmentLimit =  GwtSerDerUtils.LONG.deserialize(autoDetachmentLimitJSON);
		}
		if (!childPropertiesToIgnore.contains("maxFilesize")) {
			JSONValue maxFilesizeJSON = json.get("maxFilesize");
			ret.maxFilesize =  GwtSerDerUtils.LONG.deserialize(maxFilesizeJSON);
		}
		if (!childPropertiesToIgnore.contains("retentionTime")) {
			JSONValue retentionTimeJSON = json.get("retentionTime");
			ret.retentionTime =  GwtSerDerUtils.INT.deserialize(retentionTimeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.attachment.api.Configuration o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.attachment.api.Configuration o, JSONObject ret) {

		ret.put("autoDetachmentLimit",  GwtSerDerUtils.LONG.serialize( o.autoDetachmentLimit ));
		ret.put("maxFilesize",  GwtSerDerUtils.LONG.serialize( o.maxFilesize ));
		ret.put("retentionTime",  GwtSerDerUtils.INT.serialize( o.retentionTime ));
	}

	public void serializeTo(net.bluemind.attachment.api.Configuration o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("autoDetachmentLimit")) {
			ret.put("autoDetachmentLimit",  GwtSerDerUtils.LONG.serialize( o.autoDetachmentLimit ));
		}
		if (!childPropertiesToIgnore.contains("maxFilesize")) {
			ret.put("maxFilesize",  GwtSerDerUtils.LONG.serialize( o.maxFilesize ));
		}
		if (!childPropertiesToIgnore.contains("retentionTime")) {
			ret.put("retentionTime",  GwtSerDerUtils.INT.serialize( o.retentionTime ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}