/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.attachment.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class AttachmentSockJsEndpoint implements net.bluemind.attachment.api.IAttachmentAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public AttachmentSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/attachment/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public AttachmentSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getConfiguration(final AsyncHandler<net.bluemind.attachment.api.Configuration> handler) {
		String postUri = "/_config";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.attachment.api.Configuration>(handler) {
					@Override
			protected net.bluemind.attachment.api.Configuration handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.ConfigurationGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void share(String name, Stream document, final AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler) {
		String postUri = "/{name}/share";

		postUri = postUri.replace("{name}", URL.encodePathSegment(""+name));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.attachment.api.AttachedFile>(handler) {
					@Override
			protected net.bluemind.attachment.api.AttachedFile handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void shareDedup(String extension, Stream document, final AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler) {
		String postUri = "/{extension}/share_dedup";

		postUri = postUri.replace("{extension}", URL.encodePathSegment(""+extension));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.attachment.api.AttachedFile>(handler) {
					@Override
			protected net.bluemind.attachment.api.AttachedFile handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void unShare(String url, final AsyncHandler<Void> handler) {
		String postUri = "/{url}/unshare";

		postUri = postUri.replace("{url}", URL.encodePathSegment(""+url));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.attachment.api.IAttachmentPromise promiseApi() {
		return new AttachmentEndpointPromise(this);
	}

}
