<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CertInfo.
 */
class CertInfo  {

  /*
   * @type Set
   */
  public $usage;

  /*
   * @type []
   */
  public $x509Certificate;

  /*
   * Constructor
   */
  public function __construct() {
    $this->usage = array();
    $this->x509Certificate = array();
  }

  public function toMap() {
    $data = array(    
        "usage" => empty($this->usage) ? null : $this->usage,    
        "x509Certificate" => empty($this->x509Certificate) ? null : $this->x509Certificate);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
