package net.bluemind.cql.schemas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDescriptors {

	private static final Logger logger = LoggerFactory.getLogger(SchemaDescriptors.class);
	private static final List<CqlSchemaDescriptor> spaces = loadSchemas();

	private SchemaDescriptors() {
	}

	private static List<CqlSchemaDescriptor> loadSchemas() {
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("net.bluemind.cql.schemas",
				"descriptor");

		IExtension[] extensions = point.getExtensions();
		List<CqlSchemaDescriptor> descs = new ArrayList<>();
		for (IExtension ie : extensions) {
			Bundle bundle = Platform.getBundle(ie.getContributor().getName());
			logger.debug("loading schemas from bundle: {}", bundle.getSymbolicName());

			for (IConfigurationElement e : ie.getConfigurationElements()) {
				if (e.getName().equals("descriptor")) {
					CqlSchemaDescriptor schema = new CqlSchemaDescriptor(e.getAttribute("keyspace"),
							e.getAttribute("identifier"), bundle.getResource(e.getAttribute("schema")));
					descs.add(schema);
				}
			}
		}
		return Collections.unmodifiableList(descs);
	}

	public static List<CqlSchemaDescriptor> forKeyspace(String ksId) {
		return spaces.stream().filter(sd -> sd.keyspaceId().equalsIgnoreCase(ksId)).toList();
	}

}
