<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerUpdatesResult.
 */
class ContainerUpdatesResult  {

  /*
   * @type List
   */
  public $added;

  /*
   * @type List
   */
  public $updated;

  /*
   * @type List
   */
  public $removed;

  /*
   * @type List
   */
  public $unhandled;

  /*
   * @type List
   */
  public $errors;

  /*
   * @type long
   */
  public $version;

  /*
   * Constructor
   */
  public function __construct() {
    $this->added =  array();
    $this->updated =  array();
    $this->removed =  array();
    $this->unhandled =  array();
    $this->errors =  array();
    $this->version = 0;
  }

  public function toMap() {
    $data = array(    
        "added" => empty($this->added) ? null : $this->added,    
        "updated" => empty($this->updated) ? null : $this->updated,    
        "removed" => empty($this->removed) ? null : $this->removed,    
        "unhandled" => empty($this->unhandled) ? null : $this->unhandled,    
        "errors" => empty($this->errors) ? null : $this->errors,    
        "version" => empty($this->version) ? null : $this->version);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
