/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.api;

import jakarta.ws.rs.Path;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.ReservedIds;

@Path("/tx/outbox/{domainUid}/{owner}/{type}/{uid}")
public interface ITxOutbox {

	/**
	 * Pushes an item to the kafka outbox and returns a sequence number suitable to
	 * track when its flushed to kafka
	 * 
	 * @param <T>
	 * @param item
	 * @param deps
	 * @param deletion
	 * @return
	 */
	<T> long forKafka(ItemValue<T> item, ReservedIds deps, boolean deletion);

	boolean isPaused();

	default long lastOutboxSeq() {
		return 0L;
	}

	default long lastFlushedSeq() {
		return 0L;
	}

}
