<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * TotpCredential.
 */
class TotpCredential  {

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type String
   */
  public $secret;

  /*
   * @type String
   */
  public $token;

  /*
   * Constructor
   */
  public function __construct() {
    $this->displayName = "";
    $this->secret = "";
    $this->token = "";
  }

  public function toMap() {
    $data = array(    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "secret" => empty($this->secret) ? null : $this->secret,    
        "token" => empty($this->token) ? null : $this->token);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
