<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * HotUpgradeTaskFilter.
 */
class HotUpgradeTaskFilter  {

  /*
   * @type String
   */
  public $operation;

  /*
   * @type List
   */
  public $statuses;

  /*
   * @type boolean
   */
  public $onlyRetryable;

  /*
   * @type boolean
   */
  public $onlyReady;

  /*
   * @type boolean
   */
  public $onlyMandatory;

  /*
   * @type List
   */
  public $mode;

  /*
   * Constructor
   */
  public function __construct() {
    $this->operation = "";
    $this->statuses =  array();
    $this->onlyRetryable = false;
    $this->onlyReady = false;
    $this->onlyMandatory = false;
    $this->mode =  array();
  }

  public function toMap() {
    $data = array(    
        "operation" => empty($this->operation) ? null : $this->operation,    
        "statuses" => empty($this->statuses) ? null : $this->statuses,    
        "onlyRetryable" => empty($this->onlyRetryable) ? null : $this->onlyRetryable,    
        "onlyReady" => empty($this->onlyReady) ? null : $this->onlyReady,    
        "onlyMandatory" => empty($this->onlyMandatory) ? null : $this->onlyMandatory,    
        "mode" => empty($this->mode) ? null : $this->mode);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
