/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.delivery.rules.auditlog;

import net.bluemind.core.auditlogs.AuditLogEntry;
import net.bluemind.core.auditlogs.AuditLogUpdateStatus;
import net.bluemind.core.auditlogs.AuditLogUpdateStatus.MessageCriticity;
import net.bluemind.core.auditlogs.ILogMapperProvider;
import net.bluemind.core.container.model.ChangeLogEntry.Type;
import net.bluemind.core.container.service.internal.AuditLogService;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.delivery.rules.RuleEngine.RuleActionAndContent;

public class RuleEngineAuditLogService extends AuditLogService<RuleActionAndContent, RuleActionAndContent> {

	public RuleEngineAuditLogService(IServiceProvider prov, ILogMapperProvider<RuleActionAndContent> dm) {
		super(prov, "enginerule", dm);
	}

	@Override
	protected AuditLogEntry createAuditLogEntry(RuleActionAndContent rule, Type type) {
		AuditLogEntry auditLogEntry = new AuditLogEntry();
		auditLogEntry.logtype = type();
		auditLogEntry.content = mapper.createContentElement(rule, type);
		auditLogEntry.updatemessage = String.format("Apply rule action '%s' with parameters: '%s'", rule.action().name,
				rule.action().toString());
		return auditLogEntry;
	}

	@Override
	protected AuditLogUpdateStatus createUpdateStatus(RuleActionAndContent newValue, RuleActionAndContent oldValue) {
		return new AuditLogUpdateStatus();
	}

	public void logCreate(RuleActionAndContent value, String domainUid) {
		AuditLogEntry auditLogEntry = createAuditLogEntry(value, Type.Created);
		auditLogEntry.criticity = MessageCriticity.MAJOR;
		auditLogEntry.domainUid = domainUid;
		store(auditLogEntry);
	}

}
