import ContainerDatasource, { ContainerDB } from "@bluemind/service-worker-datasource";

vi.mock("@bluemind/service-worker-datasource", () => ({
    default: {
        retrieve: vi.fn(),
        get: vi.fn()
    }
}));

const createMockDb = (overrides = {}) => ({
    getAllItemLight: vi.fn(),
    getItems: vi.fn(),
    putItems: vi.fn(),
    putItemsAndCommit: vi.fn(),
    deleteItems: vi.fn(),
    deleteItemsAndCommit: vi.fn(),
    getSyncStatus: vi.fn(),
    updateSyncStatus: vi.fn(),
    clear: vi.fn(),
    getChanges: vi.fn(),
    getChangesSince: vi.fn(),
    ack: vi.fn(),
    getAllItems: vi.fn(),
    getChangeSet: vi.fn(),
    commit: vi.fn(),
    setSyncStatus: vi.fn(),
    close: vi.fn(),
    getConversations: vi.fn(),
    getConversationByFolder: vi.fn(),
    reset: vi.fn(),
    ...overrides
});

function mockDatasource(
    overrides: Partial<Record<"retrieve" | "get" | "register", any>> = {},
    mockDb: ContainerDB<any, any>
) {
    const methods = ["retrieve", "get", "register"] as const;
    for (const m of methods) {
        if (m in ContainerDatasource) {
            (ContainerDatasource as any)[m].mockResolvedValue(mockDb);
            if (m in overrides) {
                (ContainerDatasource as any)[m].mockResolvedValue(overrides[m]);
            }
        }
    }

    return ContainerDatasource;
}

const setupMockDatasource = (dbOverrides = {}, dateSourceOverride = {}) => {
    const mockDb = createMockDb(dbOverrides);

    const mockContainerDatasource = mockDatasource(dateSourceOverride, mockDb);
    return { mockContainerDatasource, mockDb };
};

const setupDatasourceError = () => {
    const mockRetrieve = vi.mocked(ContainerDatasource.retrieve);
    mockRetrieve.mockImplementation(() => {
        throw new Error("Datasource error");
    });
};

export { setupMockDatasource, setupDatasourceError };
